;
; ANTI TRACING BY INSTALLING A NEW INTERRUPT #1 HANDLER
;
; the program here does the following:
; switch to r0 then allocate a little amount of memory (in system area)
; then copies the new handler to that place (update the pointer in the idt)
; and give out a message box! afterwards it restores the old-one!
;
.586p
.Model Flat

extrn     ExitProcess     : PROC
extrn     MessageBoxA     : PROC

.Data                                        
for_fun                  db      "DAEMON 2K2",0
text                     db      "Interrupt Handler installed now!",0
PC_STATIC                equ     20000000h
PC_WRITEABLE             equ     00020000h      
PC_USER                  equ     00040000h      
PAGEZEROINIT             equ     00000001h
PAGEFIXED                equ     00000008h
PG_SYS                   equ     1
installed_now            dd      ?



.Code
Main:
        jmp     okay
        int     1
        push    0
        push    offset for_fun
        push    offset text
        push    0
        call    MessageBoxA
               

        call    ExitProcess

okay:
        push    edx
        sidt    [esp-2]                         ; Interrupt table to stack
        pop     edx
        add     edx,5*8+4                       ; Get interrupt vector

        mov     ebx,[edx]
        mov     bx,word ptr [edx-4]     

        lea     edi,setup

        mov     [edx-4],di
        ror     edi,16                  
        mov     [edx+2],di

        push    ds
        push    es
        int     5
        pop     es
        pop     ds

        mov     [edx-4],bx
        ror     ebx,16
        mov     [edx+2],bx

        cmp     installed_now,0
        jz      grrr
int 3
        push    0
        push    offset for_fun
        push    offset text
        push    0
        call    MessageBoxA
int 3
        push    edx
        sidt    [esp-2]                         ; Interrupt table to stack
        pop     edx
        add     edx,1*8+4                       ; Get interrupt vector
        mov     edi,old_handler
        mov     [edx-4],di                      ; store new interrupt 1 handler
        ror     edi,16                  
        mov     [edx+2],di

grrr:   call    ExitProcess

setup:  pushfd
        pushad

        push    edx
        sidt    [esp-2]                         ; Interrupt table to stack
        pop     edx
        add     edx,1*8+4                       ; Get interrupt vector

        mov     ebx,[edx]
        mov     bx,word ptr [edx-4]     

        mov     old_handler,ebx
        push    edx

        push    PAGEFIXED + PAGEZEROINIT
        xor     eax, eax
        push    eax                             ;PhysAddr
        push    eax                             ;maxPhys
        push    eax                             ;minPhys
        push    eax                             ;Align
        push    eax                             ;handle of VM = 0 if PG_SYS
        push    PG_SYS                          ;allocate memory in system area
        push    1                               ;just one page!
        db      0cdh,020h,053h,00h,01h,00h      ;VMMCall Page_Allocate
        add     esp, 8*4
        or      eax,eax                         ;eax = place in mem
        jz      back2ring3                      ;if zero error :(
        mov     edi,eax                         ;set (e)destination
        push    edi
        push    edi
        lea     esi,r0_code_start
        mov     ecx,offset r0_code_ende-offset r0_code_start
        rep     movsb       
        pop     edi
        pop     esi

        ;-----------------
        pop     edx
        mov     [edx-4],di   ; store new interrupt 1 handler
        ror     edi,16                  
        mov     [edx+2],di
        ;-----------------
        inc     installed_now
shit_happens:
        popad
        popfd
back2ring3:
        iret

;----------------------------------------------------------------------------
;
; here is the new interrupt handler (my hook)
;
;
r0_code_start equ $
        call get_me
        db "SINGLE STEP OCCOURED! (HEHE :)",10,13
        db "^DAEMON^ [UG2002]",10,13,0
get_me: db 0cdh,020h,0f3h,00h,01h,00h        ; VWIN32_Trace_Out_Service
        db 068h
;==========================================
old_handler dd ?
;==========================================
        ret

r0_code_ende equ $
;
;
;
;
;----------------------------------------------------------------------------

End Main                        ;End of code, Main is the entrypoint

